/*
 * Decompiled with CFR 0.152.
 */
package com.neoteris;

import com.neoteris.Logger;
import com.neoteris.NeoterisSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class NeoterisInetAddress {
    String a = null;
    byte[] b = null;

    public NeoterisInetAddress(String string) {
        this.a = string;
    }

    public NeoterisInetAddress(InetAddress inetAddress) {
        this.a = inetAddress.getHostName();
        this.b = inetAddress.getAddress();
    }

    public NeoterisInetAddress(NeoterisInetAddress neoterisInetAddress) {
        this.a = neoterisInetAddress.a;
        this.b = neoterisInetAddress.b;
    }

    private NeoterisInetAddress(byte[] byArray) {
        this.b = byArray;
        this.a = this.a(byArray);
    }

    private NeoterisInetAddress(String string, byte[] byArray) {
        this.b = byArray;
        this.a = string;
    }

    public static NeoterisInetAddress getByName(String string) {
        return new NeoterisInetAddress(string);
    }

    public static NeoterisInetAddress getByAddress(byte[] byArray) throws UnknownHostException {
        if (byArray.length != 4) {
            throw new UnknownHostException("Incorrect address length: " + byArray.length);
        }
        return new NeoterisInetAddress(byArray);
    }

    public static NeoterisInetAddress getByAddress(String string, byte[] byArray) throws UnknownHostException {
        if (byArray.length != 4) {
            throw new UnknownHostException("Incorrect address length: " + byArray.length);
        }
        return new NeoterisInetAddress(string, byArray);
    }

    public static NeoterisInetAddress[] getAllByName(String string) throws UnknownHostException {
        byte[][] byArray = NeoterisSocket.getAllHostAddresses(string);
        NeoterisInetAddress[] neoterisInetAddressArray = new NeoterisInetAddress[byArray.length];
        for (int k = 0; k < byArray.length; ++k) {
            neoterisInetAddressArray[k] = new NeoterisInetAddress(string, byArray[k]);
            if (!Logger.isLogging()) continue;
            Logger.log("src/NeoterisInetAddress.java", 79, 2, "Resolved " + string + " to " + neoterisInetAddressArray[k].a(byArray[k]));
        }
        return neoterisInetAddressArray;
    }

    public static NeoterisInetAddress getLocalHost() {
        return new NeoterisInetAddress((String)null);
    }

    public String getHostAddress() throws UnknownHostException {
        StringTokenizer stringTokenizer;
        int n;
        if (this.a == null) {
            return this.a().getHostAddress();
        }
        if (this.a.indexOf(45) < 0 && (n = (stringTokenizer = new StringTokenizer(this.a, ".")).countTokens()) == 4) {
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    n = 0;
                    break;
                }
            }
            if (n == 4) {
                return this.a;
            }
        }
        return this.a(this.b());
    }

    public String getHostName() {
        if (this.a == null) {
            return this.a().getHostName();
        }
        return this.a;
    }

    public int hashCode() {
        if (this.a == null) {
            return this.a().hashCode();
        }
        return this.a.hashCode();
    }

    public String toString() {
        if (this.a == null) {
            return this.a().toString();
        }
        return this.a;
    }

    public boolean isMulticastAddress() {
        return false;
    }

    public byte[] getAddress() throws UnknownHostException {
        if (this.a == null) {
            return this.a().getAddress();
        }
        if (this.b != null) {
            return this.b;
        }
        return this.b();
    }

    public boolean equals(Object object) {
        if (object instanceof NeoterisInetAddress) {
            NeoterisInetAddress neoterisInetAddress = (NeoterisInetAddress)object;
            try {
                boolean bl = neoterisInetAddress.getHostAddress().compareTo(this.getHostAddress()) == 0;
                return bl;
            }
            catch (Exception exception) {
                Logger.log("src/NeoterisInetAddress.java", 158, exception);
                return false;
            }
        }
        return false;
    }

    private String a(byte[] byArray) {
        return Integer.toString(byArray[0] & 0xFF) + "." + Integer.toString(byArray[1] & 0xFF) + "." + Integer.toString(byArray[2] & 0xFF) + "." + Integer.toString(byArray[3] & 0xFF);
    }

    private InetAddress a() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Exception exception) {
            if (Logger.isLogging()) {
                Logger.log("src/NeoterisInetAddress.java", 176, 2, "Cannot get local host: " + exception);
            }
            try {
                return InetAddress.getByName("127.0.0.1");
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    private byte[] b() throws UnknownHostException {
        if (this.b == null) {
            this.b = NeoterisSocket.getHostAddress(this.a);
            if (Logger.isLogging()) {
                Logger.log("src/NeoterisInetAddress.java", 189, 2, "Resolved " + this.a + " to " + this.a(this.b));
            }
        }
        return this.b;
    }

    public static byte[] stringToIP(String string) {
        byte[] byArray = new byte[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        try {
            int n = 0;
            for (int k = 0; k < 4; ++k) {
                n = Integer.parseInt(stringTokenizer.nextToken());
                byArray[k] = (byte)n;
            }
            return byArray;
        }
        catch (Exception exception) {
            if (Logger.isLogging()) {
                Logger.log("src/NeoterisInetAddress.java", 206, 2, "Not IP string: " + string);
            }
            return null;
        }
    }
}

