/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.HttpNAR;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import net.juniper.tnc.HttpNAR.DiameterAVP;

public class DiameterAVPSequence {
    private Collection mAVPSequence = Collections.synchronizedCollection(new Vector());

    public DiameterAVPSequence() {
    }

    public DiameterAVPSequence(byte[] byArray) throws IOException, StreamCorruptedException {
        DiameterAVP diameterAVP;
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        for (int k = byArray.length; k > 0; k -= diameterAVP.getAVPLength()) {
            byte[] byArray2 = new byte[k];
            byteBuffer.get(byArray2);
            diameterAVP = new DiameterAVP(byArray2);
            this.addAVP(diameterAVP);
            byteBuffer.position(n += diameterAVP.getAVPLength());
        }
    }

    public int getAVPCount() {
        return this.mAVPSequence.size();
    }

    public Iterator iterator() {
        return this.mAVPSequence.iterator();
    }

    public void addAVP(DiameterAVP diameterAVP) {
        this.mAVPSequence.add(diameterAVP);
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Iterator iterator = this.mAVPSequence.iterator();
        while (iterator.hasNext()) {
            byteArrayOutputStream.write(((DiameterAVP)iterator.next()).toByteArray());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void clear() {
        this.mAVPSequence.clear();
    }
}

