/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.HttpNAR;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.juniper.tnc.HttpNAR.HandshakeRetryRequestor;
import net.juniper.tnc.HttpNAR.IProxyAuth;
import net.juniper.tnc.HttpNAR.NARUtil;
import net.juniper.tnc.HttpNAR.TncHandshake;
import net.juniper.tnc.client.TNCClient;
import net.juniper.tnc.interfaces.JuniperTNCC;
import org.trustedcomputinggroup.tnc.TNCException;
import org.trustedcomputinggroup.tnc.ifimc.IMC;
import org.trustedcomputinggroup.tnc.ifimc.IMCConnection;

public abstract class HttpNAR
implements JuniperTNCC {
    private static final String cls = "HttpNAR: ";
    protected IMC mTncClient;
    protected static final int MAX_SOCKET_RETRIES = 25;
    protected static final String CMD_PORT_FILE = "narport.txt";
    private ServerSocket mSocket = null;
    protected int mSocketPort = 0;
    protected String mAppSupportDir = null;
    protected Vector mFilesToDelete = new Vector();
    protected boolean mRunning = true;
    private int mPushLogLevel = 0;
    private int mPostRetries = 0;
    private String mLocale = null;
    protected long mLoginTimeout = 0L;
    protected String mUserAgent;
    private String mHomeDir = "";
    private IProxyAuth mProxyAuth = null;
    protected TncHandshake mHandshake = null;
    private HandshakeRetryRequestor mHandshakeRequestor = new HandshakeRetryRequestor();
    public static boolean gLoggingEnabled = false;
    public static String gIveHost = null;

    @Override
    public void requestHandshakeRetry(IMC iMC, long l) throws TNCException {
    }

    @Override
    public void reportMessageTypes(IMC iMC, long[] lArray) throws TNCException {
    }

    @Override
    public void logError(String string) {
        NARUtil.logError(string);
    }

    @Override
    public void logWarning(String string) {
        NARUtil.logInfo(string);
    }

    @Override
    public void logNormal(String string) {
        NARUtil.logInfo(string);
    }

    @Override
    public void logDetail(String string) {
        NARUtil.logInfo(string);
    }

    @Override
    public void logDebug(String string) {
        NARUtil.logInfo(string);
    }

    public void stop() {
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress("localhost", this.mSocketPort);
            NARUtil.logInfo("HttpNAR: connecting to " + inetSocketAddress.toString());
            Socket socket = new Socket();
            socket.connect(inetSocketAddress);
            NARUtil.logInfo("HttpNAR: writing stop action to connection");
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream());
            printWriter.println("stop");
            printWriter.close();
            socket.close();
        }
        catch (Exception exception) {
            NARUtil.logException(exception);
        }
    }

    public void scheduleHandshakeRetry(long l, IMCConnection iMCConnection) {
        long l2 = l * 60L * 1000L + new Date().getTime();
        this.mHandshakeRequestor.requestHandshakeRetry(l2, iMCConnection, 3L);
    }

    public void initialize(String[] stringArray) throws Exception {
        Properties properties = this.getProgramArguments(stringArray);
        gIveHost = properties.getProperty("ivehost");
        this.mLocale = properties.getProperty("locale");
        this.mUserAgent = properties.getProperty("user_agent");
        String string = properties.getProperty("log_level");
        this.mPostRetries = NARUtil.getInt(properties.getProperty("postRetries"), "postRetries", 1);
        String string2 = properties.getProperty("Parameter0");
        this.mHomeDir = properties.getProperty("home_dir");
        Properties properties2 = NARUtil.parseParameters(string2, ';');
        this.mLoginTimeout = NARUtil.getLong(properties2.getProperty("process_timeout"), "process_timeout", 0L);
        String string3 = properties.getProperty("dsProxyHost");
        String string4 = properties.getProperty("dsProxyPort");
        boolean bl = gLoggingEnabled = NARUtil.getInt(properties2.getProperty("logging"), "logging", 0) == 1;
        if (this.mHomeDir.length() == 0) {
            this.mHomeDir = System.getProperty("user.home");
        }
        if (gLoggingEnabled) {
            this.mPushLogLevel = NARUtil.startLogging(string);
            NARUtil.logInfo("=====================================================");
            NARUtil.logInfo("HttpNAR: starting");
            NARUtil.logInfo("HttpNAR: ivehost     = " + gIveHost);
            NARUtil.logInfo("HttpNAR: locale      = " + this.mLocale);
            NARUtil.logInfo("HttpNAR: home_dir    = " + this.mHomeDir);
            NARUtil.logInfo("HttpNAR: user_agent  = " + this.mUserAgent);
            NARUtil.logInfo("HttpNAR: log_level   = " + string);
            NARUtil.logInfo("HttpNAR: postRetries = " + this.mPostRetries);
            NARUtil.logInfo("HttpNAR: Proxy = " + string3 + ":" + string4);
            NARUtil.logInfo("HttpNAR: Parameter0  = " + string2);
        }
        NARUtil.logInfo("HttpNAR: Running as `" + System.getProperty("user.name") + "', home dir `" + System.getProperty("user.home") + "'");
        NARUtil.logInfo("HttpNAR: running on " + NARUtil.getOSName());
        if (!this.isPlatformSupported()) {
            NARUtil.logError("HttpNAR: unsupported operating system " + NARUtil.getOSName() + "; stopping...");
            throw new Exception("Unsupported operating system");
        }
        this.mAppSupportDir = this.getPlatformSupportDir(this.mHomeDir);
        String string5 = System.getProperty("https.proxyHost");
        String string6 = System.getProperty("https.proxyPort");
        this.mProxyAuth = NARUtil.getProxyAuth();
        if (this.mProxyAuth != null) {
            this.mProxyAuth.Initialize(null, null, this.mLocale);
        }
        if (!NARUtil.isEmpty(string5) || !NARUtil.isEmpty(string6)) {
            NARUtil.logInfo("HttpNAR: will connect to IVE through a proxy at " + string5 + ":" + string6);
        } else if (!NARUtil.isEmpty(string3) || !NARUtil.isEmpty(string4)) {
            NARUtil.logInfo("dsProxyHost=" + string3 + ", dsProxyPort=" + string4);
            System.setProperty("https.proxyHost", string3);
            System.setProperty("https.proxyPort", string4);
        } else {
            NARUtil.logInfo("HttpNAR: will connect to IVE directly");
        }
        this.mTncClient = new TNCClient();
        this.mTncClient.initialize(this);
        this.loadbundledIMC();
        this.mHandshakeRequestor.start();
        this.allowHostnameMismatch();
    }

    protected abstract void loadbundledIMC();

    protected abstract String getPlatformSupportDir(String var1);

    protected abstract boolean isPlatformSupported();

    public void run() {
        try {
            this.createCommandSocket();
            this.processCommands();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            NARUtil.logException(exception);
        }
    }

    @Override
    public abstract ClassLoader getClassloader();

    protected void terminate() throws TNCException {
        if (null != this.mTncClient) {
            this.mTncClient.terminate();
            this.mTncClient = null;
            this.mHandshakeRequestor.terminate();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        NARUtil.logInfo("HttpNAR: stopped");
        if (gLoggingEnabled) {
            NARUtil.stopLogging(this.mPushLogLevel);
        }
        try {
            this.deletePortFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract void deletePortFile();

    private void createCommandSocket() throws Exception {
        this.mSocket = new ServerSocket(0);
        this.mSocketPort = this.mSocket.getLocalPort();
        NARUtil.logInfo("HttpNAR: created a socket on port " + this.mSocketPort);
        this.writePortInfo();
        System.out.println("socket opened");
        System.out.flush();
    }

    protected abstract void writePortInfo() throws FileNotFoundException;

    private void processCommands() throws IOException {
        while (this.mRunning) {
            int n;
            NARUtil.logInfo("HttpNAR: wait for connection to port " + this.mSocketPort);
            Socket socket = null;
            InetSocketAddress inetSocketAddress = null;
            for (n = 0; !(n >= 25 || (inetSocketAddress = (InetSocketAddress)(socket = this.mSocket.accept()).getRemoteSocketAddress()) != null && inetSocketAddress.getAddress().isLoopbackAddress()); ++n) {
                socket.close();
                NARUtil.logError("HttpNAR: incoming non-loopback connection from " + inetSocketAddress.toString() + "; rejected");
            }
            if (n < 25) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String string = bufferedReader.readLine();
                if (string != null) {
                    NARUtil.logInfo("HttpNAR: read action `" + string + "' from " + inetSocketAddress.toString());
                }
                if (string.equals("stop")) {
                    this.processStop();
                    continue;
                }
                if (string.equals("FinishHS")) {
                    this.processFinishHS();
                    continue;
                }
                if (string.equals("start")) {
                    this.processStart(socket, bufferedReader);
                    continue;
                }
                if (string.equals("setcookie")) {
                    NARUtil.logInfo("HttpNAR: read DSPREAUTH cookie from " + inetSocketAddress.toString());
                    if (null == this.mHandshake) continue;
                    this.mHandshake.updateCookie(bufferedReader);
                    continue;
                }
                if (string.equals("tryagain")) {
                    if (null == this.mHandshake) continue;
                    this.mHandshake.tryAgain(socket.getOutputStream());
                    continue;
                }
                if (string.equals("hideremedpage")) {
                    if (null == this.mHandshake) continue;
                    this.mHandshake.setShowRemediationData(false);
                    continue;
                }
                if (string.equals("showremedpage")) {
                    if (null == this.mHandshake) continue;
                    this.mHandshake.setShowRemediationData(true);
                    continue;
                }
                NARUtil.logError("HttpNAR: read unknown action " + string + " from " + inetSocketAddress.toString() + "; ignored");
                continue;
            }
            NARUtil.logError("HttpNAR: exceeded max socket retries (25; shutting down");
            this.mRunning = false;
        }
    }

    protected abstract void processStart(Socket var1, BufferedReader var2) throws IOException;

    protected abstract void processFinishHS();

    protected abstract void processStop();

    private void trustAllCerts() throws Exception {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        }};
        SSLContext sSLContext = SSLContext.getInstance(NARUtil.getSSLProtocol());
        sSLContext.init(null, trustManagerArray, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
    }

    private void allowHostnameMismatch() {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
    }

    private Properties getProgramArguments(String[] stringArray) {
        Properties properties = new Properties();
        String string = null;
        String string2 = null;
        for (int k = 0; k < stringArray.length; ++k) {
            if (string == null) {
                string = stringArray[k];
                continue;
            }
            string2 = stringArray[k];
            properties.setProperty(string, string2);
            string = null;
        }
        return properties;
    }
}

