/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.HttpNAR;

import java.nio.ByteBuffer;
import java.util.Locale;
import net.juniper.tnc.HttpNAR.DiameterAVP;
import net.juniper.tnc.HttpNAR.DiameterAVPSequence;
import net.juniper.tnc.HttpNAR.NARUtil;
import net.juniper.tnc.HttpNAR.TncHandshake;
import net.juniper.tnc.interfaces.JuniperIMCConnection;
import net.juniper.tnc.interfaces.JuniperIMCParams;
import org.trustedcomputinggroup.tnc.TNCException;

public class TncConnection
implements JuniperIMCConnection {
    private static final String cls = "TncConnection: ";
    private long mState = 0L;
    private TncHandshake mHandshake = null;
    private JuniperIMCParams mIMCParams = null;
    private DiameterAVPSequence mAvpSequence = new DiameterAVPSequence();

    public TncConnection(TncHandshake tncHandshake) {
        this.mHandshake = tncHandshake;
    }

    @Override
    public void sendMessage(long l, byte[] byArray) throws TNCException {
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4 + byArray.length);
            byteBuffer.putInt((int)l);
            byteBuffer.put(byArray);
            this.mAvpSequence.addAVP(new DiameterAVP(3303, -1073741824, 1411, byteBuffer.array()));
        }
        catch (Exception exception) {
            throw new TNCException(exception.getMessage(), 9L);
        }
    }

    @Override
    public void requestHandshakeRetry(long l) throws TNCException {
        if (null != this.mHandshake) {
            this.mHandshake.retryHandshake();
        } else {
            NARUtil.logError("TncConnection: handshake requested on invalid connection: state(" + this.mState + "), ptr " + this.mHandshake);
        }
    }

    public void clear() {
        this.mAvpSequence.clear();
    }

    public void close() {
        NARUtil.logInfo("TncConnection: connection closed.");
        this.mState = 5L;
    }

    public byte[] getAccumulatedMessages() throws TNCException {
        byte[] byArray;
        Locale locale = Locale.getDefault();
        String string = "Accept-Language: " + locale.getLanguage();
        try {
            DiameterAVP diameterAVP = new DiameterAVP(3300, -1073741824, 1411, this.mAvpSequence.toByteArray());
            DiameterAVPSequence diameterAVPSequence = new DiameterAVPSequence();
            diameterAVPSequence.addAVP(diameterAVP);
            diameterAVPSequence.addAVP(new DiameterAVP(3301, -1073741824, 1411, string.getBytes()));
            DiameterAVP diameterAVP2 = new DiameterAVP(19, -1073741824, 1411, diameterAVPSequence.toByteArray());
            byArray = diameterAVP2.toByteArray();
        }
        catch (Exception exception) {
            throw new TNCException(exception.getMessage(), 9L);
        }
        return byArray;
    }

    @Override
    public void setIMCParams(JuniperIMCParams juniperIMCParams) {
        this.mIMCParams = juniperIMCParams;
    }

    public JuniperIMCParams getmIMCParams() {
        return this.mIMCParams;
    }
}

