/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.NARPlatform.linux;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import net.juniper.tnc.HttpNAR.HttpNAR;
import net.juniper.tnc.HttpNAR.NARUtil;
import net.juniper.tnc.HttpNAR.TncHandshake;
import net.juniper.tnc.NARPlatform.linux.LinuxNARlatform;
import net.juniper.tnc.client.TNCClient;

public final class LinuxHttpNAR
extends HttpNAR {
    private static final String cls = "LinuxHttpNAR: ";

    public static void main(String[] stringArray) {
        try {
            LinuxHttpNAR linuxHttpNAR = new LinuxHttpNAR();
            linuxHttpNAR.initialize(stringArray);
            linuxHttpNAR.run();
            linuxHttpNAR.terminate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            NARUtil.logException(exception);
        }
    }

    @Override
    protected void writePortInfo() throws FileNotFoundException {
        String string = this.mAppSupportDir + "narport.txt";
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
        printWriter.println(this.mSocketPort);
        printWriter.close();
        this.mFilesToDelete.add(string);
        NARUtil.logInfo("LinuxHttpNAR: wrote port to " + string);
    }

    @Override
    protected void deletePortFile() {
        String string = this.mAppSupportDir + "narport.txt";
        File file = new File(string);
        file.delete();
    }

    @Override
    protected boolean isPlatformSupported() {
        return NARUtil.isLinux() || NARUtil.isMacOSX() || NARUtil.isSolaris();
    }

    @Override
    protected String getPlatformSupportDir(String string) {
        return string + (NARUtil.isMacOSX() ? "/Library/Application Support/Juniper Networks/" : (NARUtil.isLinux() || NARUtil.isSolaris() ? "/.pulse_secure/" : "/"));
    }

    @Override
    protected void loadbundledIMC() {
        if (null != this.mTncClient) {
            String string = "Juniper Networks - HC IMC";
            String string2 = "net.juniper.tnc.hostcheckerimc.HostCheckerIMC";
            ((TNCClient)this.mTncClient).loadbundledIMC(string, null, string2, 1);
        }
    }

    @Override
    protected void processStart(Socket socket, BufferedReader bufferedReader) throws IOException {
        this.mHandshake = new TncHandshake(this, this.mTncClient, this.mUserAgent, this.mLoginTimeout);
        this.mHandshake.runHandshake(bufferedReader, socket.getOutputStream());
    }

    @Override
    protected void processFinishHS() {
    }

    @Override
    protected void processStop() {
        this.mRunning = false;
        this.processFinishHS();
    }

    @Override
    public ClassLoader getClassloader() {
        return ClassLoader.getSystemClassLoader();
    }

    static {
        try {
            NARUtil.PlatformUtil = new LinuxNARlatform();
        }
        catch (Exception exception) {
            NARUtil.PlatformUtil = LinuxNARlatform.getPlatform();
        }
    }
}

