/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.client;

import net.juniper.tnc.client.IMCCollection;
import net.juniper.tnc.client.IMCModule;
import net.juniper.tnc.client.TNCCUtil;
import net.juniper.tnc.interfaces.JuniperIMCConnection;
import net.juniper.tnc.interfaces.JuniperIMCParams;
import org.trustedcomputinggroup.tnc.TNCException;
import org.trustedcomputinggroup.tnc.ifimc.IMCConnection;

public class HandshakeEngine
implements IMCConnection {
    private static final String cls = "HandshakeEngine: ";
    private Object[] mIMCSnapshot;
    private IMCConnection mNARConnection = null;
    private long mState = 0L;
    private boolean mAccumulateMessages = false;

    public HandshakeEngine(IMCConnection iMCConnection, IMCCollection iMCCollection) {
        this.mNARConnection = iMCConnection;
        this.mIMCSnapshot = iMCCollection.makeSnapshot();
    }

    @Override
    public void sendMessage(long l, byte[] byArray) throws TNCException {
        if (!this.mAccumulateMessages) {
            throw new TNCException("Invalid connection state.", 8L);
        }
        this.mNARConnection.sendMessage(l, byArray);
    }

    @Override
    public void requestHandshakeRetry(long l) throws TNCException {
        if (5L == this.mState) {
            throw new TNCException("Can not request handshake retry on deleted connection.", 8L);
        }
        this.mNARConnection.requestHandshakeRetry(l);
    }

    public void beginHandshake(IMCConnection iMCConnection) throws TNCException {
        this.mNARConnection = iMCConnection;
        this.mAccumulateMessages = true;
        for (int k = 0; k < this.mIMCSnapshot.length; ++k) {
            IMCModule iMCModule = (IMCModule)this.mIMCSnapshot[k];
            try {
                iMCModule.getInterface().beginHandshake(this);
                continue;
            }
            catch (TNCException tNCException) {
                TNCCUtil.logError("HandshakeEngine: beginHandshake of `" + iMCModule.getName() + "' returned with error \"" + tNCException.getMessage() + "\"");
                TNCCUtil.logException(tNCException);
            }
        }
        this.mAccumulateMessages = false;
    }

    public void receiveMessage(IMCConnection iMCConnection, long l, byte[] byArray) throws TNCException {
        try {
            this.mNARConnection = iMCConnection;
            this.mAccumulateMessages = true;
            for (int k = 0; k < this.mIMCSnapshot.length; ++k) {
                IMCModule iMCModule = (IMCModule)this.mIMCSnapshot[k];
                if (!iMCModule.isRegisteredMessageType(l)) continue;
                try {
                    iMCModule.getInterface().receiveMessage(this, l, byArray);
                    continue;
                }
                catch (TNCException tNCException) {
                    TNCCUtil.logError("HandshakeEngine: receiveMessage of `" + iMCModule.getName() + "' returned with error \"" + tNCException.getMessage() + "\"");
                    TNCCUtil.logException(tNCException);
                }
            }
        }
        catch (Exception exception) {
            throw new TNCException(exception.getMessage(), 9L);
        }
        this.mAccumulateMessages = false;
    }

    public void notifyConnectionChange(IMCConnection iMCConnection, long l) throws TNCException {
        this.mState = l;
        this.mNARConnection = iMCConnection;
        for (int k = 0; k < this.mIMCSnapshot.length; ++k) {
            IMCModule iMCModule = (IMCModule)this.mIMCSnapshot[k];
            try {
                iMCModule.getInterface().notifyConnectionChange(this, l);
                continue;
            }
            catch (TNCException tNCException) {
                TNCCUtil.logError("HandshakeEngine: notifyConnectionChange of `" + iMCModule.getName() + "' returned with error \"" + tNCException.getMessage() + "\"");
                TNCCUtil.logException(tNCException);
            }
        }
    }

    public void batchEnding(IMCConnection iMCConnection) throws TNCException {
        this.mAccumulateMessages = true;
        this.mNARConnection = iMCConnection;
        for (int k = 0; k < this.mIMCSnapshot.length; ++k) {
            IMCModule iMCModule = (IMCModule)this.mIMCSnapshot[k];
            try {
                iMCModule.getInterface().batchEnding(this);
                continue;
            }
            catch (TNCException tNCException) {
                TNCCUtil.logError("HandshakeEngine: notifyConnectionChange of `" + iMCModule.getName() + "' returned with error \"" + tNCException.getMessage() + "\"");
                TNCCUtil.logException(tNCException);
            }
        }
        this.mAccumulateMessages = false;
    }

    public void setIMCParams(JuniperIMCParams juniperIMCParams) {
        if (this.mNARConnection instanceof JuniperIMCConnection) {
            ((JuniperIMCConnection)this.mNARConnection).setIMCParams(juniperIMCParams);
        }
    }
}

