/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.client;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.juniper.tnc.interfaces.JuniperTNCC;

public class TNCCUtil {
    private static JuniperTNCC mNARItf;

    public static void startLogging(JuniperTNCC juniperTNCC) {
        mNARItf = juniperTNCC;
    }

    public static void stopLogging() {
        mNARItf = null;
    }

    public static void logError(String string) {
        if (null != mNARItf) {
            mNARItf.logError(string);
        }
    }

    public static void logInfo(String string) {
        if (null != mNARItf) {
            mNARItf.logNormal(string);
        }
    }

    public static void logException(Exception exception) {
        if (null != mNARItf) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            exception.printStackTrace(printStream);
            mNARItf.logError("TNCCUtil: *** EXCEPTION ***\n" + byteArrayOutputStream.toString());
        }
    }

    public static void logData(byte[] byArray) {
        int n;
        int n2 = 16;
        int n3 = 2;
        char[] cArray = new char[4 * n2 + n3];
        int n4 = 0;
        for (int k = byArray.length; k != 0; k -= n) {
            for (n = 0; n < cArray.length; ++n) {
                cArray[n] = 32;
            }
            n = k <= n2 ? k : n2;
            for (int i2 = 0; i2 < n; ++i2) {
                byte by = byArray[i2 + n4];
                cArray[3 * i2] = Character.forDigit((by & 0xF0) >>> 4, 16);
                cArray[3 * i2 + 1] = Character.forDigit(by & 0xF, 16);
                cArray[3 * n2 + n3 + i2] = by >= 32 && by <= 127 ? (int)by : 46;
            }
            n4 += n;
            TNCCUtil.logInfo(String.valueOf(cArray));
        }
    }

    static int getInt(String string, String string2, int n) {
        int n2 = n;
        if (!TNCCUtil.isEmpty(string)) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                TNCCUtil.logError("Invalid value for " + string2 + "=" + string + "; expected integer; using default = " + n);
            }
        } else {
            TNCCUtil.logInfo("Using default for " + string2 + "=" + n);
        }
        return n2;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = null;
        if (null != mNARItf) {
            classLoader = mNARItf.getClassloader();
        }
        return classLoader;
    }
}

