/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.hostcheckerimc;

import java.util.HashSet;
import net.juniper.tnc.hostcheckerimc.HCPortEnum;
import net.juniper.tnc.hostcheckerimc.HCUtil;

public class HCPortEnumSunOS
implements HCPortEnum {
    private final String cls = "HCPortEnumSunOS: ";

    @Override
    public HashSet enumPorts() {
        HashSet hashSet = new HashSet();
        if (!this.processNetstatCommand("netstat -an -f af:inet -P tcp", '.', hashSet)) {
            return hashSet;
        }
        if (!this.processNetstatCommand("netstat -an -f af:inet -P udp", '.', hashSet)) {
            return hashSet;
        }
        HCUtil.logInfo("HCPortEnumSunOS: found " + hashSet.size() + " open ports");
        return hashSet;
    }

    private boolean processNetstatCommand(String string, char c2, HashSet hashSet) {
        int n;
        HCUtil.logInfo("HCPortEnumSunOS: executing command " + string);
        String string2 = HCUtil.execCommand(string);
        if (string2 == null) {
            HCUtil.logError("HCPortEnumSunOS: cannot get current open ports.");
            return false;
        }
        int n2 = -1;
        for (n = 0; n < 4; ++n) {
            if ((n2 = string2.indexOf(10, n2 + 1)) != -1 && n2 != string2.length() - 1) continue;
            HCUtil.logError("HCPortEnumSunOS: bad output from netstat: missing headers\n" + string2);
            return false;
        }
        n = 0;
        while ((n2 = string2.indexOf(10, n = n2 + 1)) != -1) {
            String[] stringArray = string2.substring(n, n2).trim().split("\\s+");
            if (0 == stringArray.length) {
                HCUtil.logError("HCPortEnumSunOS: bad output from netstat: missing local address " + string2);
                break;
            }
            int n3 = stringArray[0].lastIndexOf(c2);
            if (n3 == -1 || n3 + 1 == stringArray[0].length()) {
                HCUtil.logError("HCPortEnumSunOS: bad output from netstat: missing port in local address " + stringArray[0] + ":\n" + string2);
                break;
            }
            String string3 = stringArray[0].substring(n3 + 1).trim();
            if (string3.equals("*")) continue;
            int n4 = 0;
            try {
                n4 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                HCUtil.logError("HCPortEnumSunOS: bad output from netstat: invalid port in local address " + stringArray[0] + ":\n" + string2);
                break;
            }
            hashSet.add(new Integer(n4));
        }
        return true;
    }
}

