/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.hostcheckerimc;

import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import net.juniper.tnc.hostcheckerimc.HCPortEnum;
import net.juniper.tnc.hostcheckerimc.HCPortEnumLinux;
import net.juniper.tnc.hostcheckerimc.HCPortEnumMac;
import net.juniper.tnc.hostcheckerimc.HCPortEnumSunOS;
import net.juniper.tnc.hostcheckerimc.HCRule;
import net.juniper.tnc.hostcheckerimc.HCUtil;
import net.juniper.tnc.hostcheckerimc.HostChecker;

public class HCPortRule
extends HCRule {
    private final String cls = "HCPortRule: ";
    private int[] mPortsLow = null;
    private int[] mPortsHigh = null;
    private boolean mFlag = true;
    private HCPortEnum mPortEnumInterface = null;

    public HCPortRule(Properties properties, int n) {
        super(properties, n);
        if (properties == null) {
            return;
        }
        this.mPortEnumInterface = HostChecker.gIsMac ? new HCPortEnumMac() : (HostChecker.gIsSunOS ? new HCPortEnumSunOS() : new HCPortEnumLinux());
        String string = properties.getProperty("port" + n);
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n2 = stringTokenizer.countTokens();
            this.mPortsLow = new int[n2];
            this.mPortsHigh = new int[n2];
            boolean bl = false;
            for (int k = 0; k < n2 && stringTokenizer.hasMoreTokens() && !bl; ++k) {
                String string2 = stringTokenizer.nextToken();
                int n3 = 0;
                int n4 = 0;
                int n5 = string2.indexOf(45);
                try {
                    if (n5 != -1) {
                        if (n5 < string2.length() - 1) {
                            n3 = Integer.parseInt(string2.substring(0, n5).trim());
                            if (n3 <= (n4 = Integer.parseInt(string2.substring(n5 + 1).trim()))) {
                                this.mPortsLow[k] = n3;
                                this.mPortsHigh[k] = n4;
                            } else {
                                HCUtil.logError("HCPortRule: low port not <= high port in range " + string2 + " in port list");
                                bl = true;
                                n4 = 0;
                                n3 = 0;
                            }
                        } else {
                            HCUtil.logError("HCPortRule: missing high port in range " + string2 + " in port list");
                            bl = true;
                            n4 = 0;
                            n3 = 0;
                        }
                    } else {
                        n3 = n4 = Integer.parseInt(string2.trim());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    HCUtil.logError("HCPortRule: invalid port number(s) in range " + string2 + " in port list");
                    bl = true;
                    n4 = 0;
                    n3 = 0;
                }
                this.mPortsLow[k] = n3;
                this.mPortsHigh[k] = n4;
            }
            if (!bl) {
                this.mFlag = HCUtil.getBoolInt(properties.getProperty("flag" + n), "flag" + n, true);
            }
        } else {
            HCUtil.logError("No or empty port" + n + " in policy " + this.mPolicyId);
        }
    }

    @Override
    public String evaluate() {
        String string = null;
        HashSet hashSet = this.mPortEnumInterface.enumPorts();
        for (int k = 0; k < this.mPortsLow.length && string == null; ++k) {
            int n = this.mPortsLow[k];
            int n2 = this.mPortsHigh[k];
            if (n == 0 || n2 == 0) continue;
            String string2 = n != n2 ? n + "-" + n2 : "" + n;
            for (int i2 = n; i2 <= n2 && string == null; ++i2) {
                boolean bl = hashSet.contains(new Integer(i2));
                if (!this.mFlag && bl) {
                    HCUtil.logInfo("HCPortRule: denied port is open");
                    string = "Denied port is open";
                    continue;
                }
                if (!this.mFlag || bl) continue;
                HCUtil.logInfo("HCPortRule: required port is not open");
                string = "Required port is not open";
            }
            if (string == null && !this.mFlag) {
                HCUtil.logInfo("HCPortRule: denied port(s) not open");
                continue;
            }
            if (string != null || !this.mFlag) continue;
            HCUtil.logInfo("HCPortRule: required port(s) open");
        }
        return string;
    }
}

