/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.hostcheckerimc;

import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import net.juniper.tnc.hostcheckerimc.HCProcessEnum;
import net.juniper.tnc.hostcheckerimc.HCRule;
import net.juniper.tnc.hostcheckerimc.HCUtil;

public class HCProcessRule
extends HCRule {
    static final String cls = "HCProcessRule: ";
    private String mName;
    private String mChecksumsString;
    private String mChecksumsSha256String;
    private String[] mChecksums;
    private String[] mChecksumsSha256;
    private boolean mFlag;
    private HCProcessEnum mEnum = new HCProcessEnum();

    public HCProcessRule(Properties properties, int n) {
        super(properties, n);
        if (properties == null) {
            return;
        }
        this.mName = properties.getProperty("process" + n);
        if (!HCUtil.isEmpty(this.mName)) {
            int n2;
            int n3;
            StringTokenizer stringTokenizer;
            this.mChecksumsString = properties.getProperty("cksum" + n);
            if (this.mChecksumsString != null && !HCUtil.isEmpty(this.mChecksumsString = this.mChecksumsString.trim())) {
                stringTokenizer = new StringTokenizer(this.mChecksumsString, ",");
                n3 = stringTokenizer.countTokens();
                this.mChecksums = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.mChecksums[n2] = (String)stringTokenizer.nextElement();
                }
            }
            this.mChecksumsSha256String = properties.getProperty("sha256cksum");
            if (this.mChecksumsSha256String != null && !HCUtil.isEmpty(this.mChecksumsSha256String = this.mChecksumsSha256String.trim())) {
                stringTokenizer = new StringTokenizer(this.mChecksumsSha256String, ",");
                n3 = stringTokenizer.countTokens();
                this.mChecksumsSha256 = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.mChecksumsSha256[n2] = (String)stringTokenizer.nextElement();
                }
            }
            this.mFlag = HCUtil.getBoolInt(properties.getProperty("flag" + n), "flag" + n, true);
        } else {
            HCUtil.logError("No or empty process" + n + " in policy " + this.mPolicyId);
        }
    }

    public HCProcessRule() {
    }

    private static String getPath(String string) {
        String string2 = "";
        HCUtil.logInfo("HCProcessRule: executing which " + string);
        String string3 = HCUtil.execCommand("which " + string);
        if (!HCUtil.isEmpty(string3)) {
            HCUtil.logInfo("HCProcessRule: whereis output = " + string3);
            int n = string3.lastIndexOf(File.separator);
            string2 = string3.substring(0, n + 1);
            HCUtil.logInfo("HCProcessRule: path for command " + string + " = " + string2);
        } else {
            HCUtil.logError("HCProcessRule: whereis " + string + "failed; cannot get path");
        }
        return string2;
    }

    private String checkChecksum(String string, String string2) {
        String string3 = null;
        String string4 = HCProcessEnum.computeChecksum(string);
        if (!string2.equalsIgnoreCase(string4)) {
            string3 = "Checksum does not match";
        }
        return string3;
    }

    @Override
    public String evaluate() {
        String string = null;
        this.mEnum.enumerate();
        Vector vector = this.mEnum.expandProcessNames(this.mName);
        boolean bl = false;
        for (int k = 0; k < vector.size() && string == null; ++k) {
            String string2 = (String)vector.get(k);
            Vector vector2 = (Vector)this.mEnum.mProcessNames.get(string2);
            boolean bl2 = false;
            if (vector2 != null) {
                for (int i2 = 0; i2 < vector2.size() && !bl2; ++i2) {
                    if (this.mChecksums != null || this.mChecksumsSha256 != null) {
                        int n;
                        String string3;
                        bl = true;
                        String string4 = (String)vector2.get(i2);
                        if (!string4.startsWith(File.separator)) {
                            string4 = HCProcessRule.getPath(string2) + string2;
                        }
                        boolean bl3 = true;
                        boolean bl4 = true;
                        if (this.mChecksums != null) {
                            bl3 = false;
                            string3 = HCProcessEnum.computeChecksum(string4);
                            if (string3 != null) {
                                for (n = 0; n < this.mChecksums.length && !bl3; ++n) {
                                    bl3 = string3.equalsIgnoreCase(this.mChecksums[n]);
                                }
                                HCUtil.logInfo("HCProcessRule: MD5: file actual checksum " + (bl3 ? "matches " : "does not match ") + "an expected checksum");
                            } else {
                                HCUtil.logError("couldn't compute process MD5 checksum");
                            }
                        }
                        if (this.mChecksumsSha256 != null) {
                            bl4 = false;
                            string3 = HCProcessEnum.computeSha256Checksum(string4);
                            if (string3 != null) {
                                for (n = 0; n < this.mChecksumsSha256.length && !bl4; ++n) {
                                    bl4 = string3.equalsIgnoreCase(this.mChecksumsSha256[n]);
                                }
                                HCUtil.logInfo("HCProcessRule: SHA256: file actual checksum " + (bl4 ? "matches " : "does not match ") + "an expected checksum");
                            } else {
                                HCUtil.logError("couldn't compute process SHA256 checksum");
                            }
                        }
                        bl2 = bl3 && bl4;
                        continue;
                    }
                    bl2 = true;
                }
            }
            if (!this.mFlag) {
                HCUtil.logInfo("HCProcessRule: denied process " + (bl2 ? " is" : " is not") + " running");
                if (!bl2) continue;
                string = "Found restricted process";
                continue;
            }
            HCUtil.logInfo("HCProcessRule: required process " + (bl2 ? " is" : " is not") + " running");
            if (bl2) continue;
            string = bl ? "Required process not found or checksum did not match" : "Required process not found";
        }
        if (vector.size() == 0) {
            if (this.mFlag) {
                HCUtil.logInfo("HCProcessRule: no processes matching required pattern ");
                string = "Required process not running";
            } else {
                HCUtil.logInfo("HCProcessRule: no processes matching denied pattern ");
            }
        }
        return string;
    }
}

