/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.hostcheckerimc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Properties;
import net.juniper.tnc.hostcheckerimc.CommandOutputThread;
import net.juniper.tnc.interfaces.JuniperTNCC;

public class HCUtil {
    private static JuniperTNCC mTNCCItf;

    public static void startLogging(JuniperTNCC juniperTNCC) {
        mTNCCItf = juniperTNCC;
    }

    public static void stopLogging() {
        mTNCCItf = null;
    }

    public static void logError(String string) {
        if (null != mTNCCItf) {
            mTNCCItf.logError(string);
        }
    }

    public static void logInfo(String string) {
        if (null != mTNCCItf) {
            mTNCCItf.logNormal(string);
        }
    }

    public static void logException(Exception exception) {
        if (null != mTNCCItf) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            exception.printStackTrace(printStream);
            mTNCCItf.logError("TNCCUtil: *** EXCEPTION ***\n" + byteArrayOutputStream.toString());
        }
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    static byte[] hexStringToBytes(String string) {
        byte[] byArray = null;
        if (string.length() % 2 == 0) {
            try {
                byArray = new byte[string.length() / 2];
                for (int k = 0; k < byArray.length; ++k) {
                    byArray[k] = (byte)Integer.parseInt(string.substring(2 * k, 2 * k + 2), 16);
                }
            }
            catch (NumberFormatException numberFormatException) {
                byArray = null;
            }
        }
        return byArray;
    }

    static String bytesToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(2 * byArray.length);
        for (int k = 0; k < byArray.length; ++k) {
            stringBuffer.append(Character.forDigit((byArray[k] & 0xF0) >>> 4, 16));
            stringBuffer.append(Character.forDigit(byArray[k] & 0xF, 16));
        }
        return stringBuffer.toString();
    }

    public static Properties parseParameters(String string, char c2) {
        Properties properties = new Properties();
        int n = 0;
        while (n < string.length()) {
            String string2 = null;
            String string3 = null;
            int n2 = string.indexOf(61, n);
            int n3 = string.indexOf(c2, n);
            if (n2 != -1 && (n3 == -1 || n2 < n3)) {
                string2 = string.substring(n, n2).trim();
                n = n2 + 1;
                if (n3 != -1) {
                    string3 = string.substring(n, n3).trim();
                    n = n3 + 1;
                } else {
                    string3 = string.substring(n).trim();
                    n = string.length();
                }
                properties.setProperty(string2, string3);
                continue;
            }
            n = n3 != -1 ? n3 + 1 : string.length();
        }
        return properties;
    }

    static int getInt(String string, String string2, int n) {
        int n2 = n;
        if (!HCUtil.isEmpty(string)) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                HCUtil.logError("Invalid value for " + string2 + "=" + string + "; expected integer; using default = " + n);
            }
        } else {
            HCUtil.logInfo("Using default for " + string2 + "=" + n);
        }
        return n2;
    }

    public static boolean getBoolInt(String string, String string2, boolean bl) {
        boolean bl2 = bl;
        int n = HCUtil.getInt(string, string2, bl ? 1 : 0);
        switch (n) {
            case 0: {
                bl2 = false;
                break;
            }
            case 1: {
                bl2 = true;
                break;
            }
            default: {
                HCUtil.logError("Invalid value for " + string2 + "=" + string + "; expected boolean; using default = " + bl);
            }
        }
        return bl2;
    }

    public static boolean containsWildcards(String string) {
        return string != null && (string.indexOf(42) != -1 || string.indexOf(37) != -1 || string.indexOf(63) != -1);
    }

    public static String convertWildcardsToRegex(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int k = 0; k < string.length(); ++k) {
            char c2 = string.charAt(k);
            if (c2 == '*') {
                stringBuffer.append(".*");
                continue;
            }
            if (c2 == '?') {
                stringBuffer.append(".");
                continue;
            }
            if (c2 == '%') {
                stringBuffer.append("[^").append(File.separator).append("]*");
                continue;
            }
            if (c2 == '+' || c2 == '[' || c2 == ']' || c2 == '(' || c2 == ')' || c2 == '|' || c2 == '^' || c2 == '$' || c2 == '.' || c2 == '{' || c2 == '}' || c2 == '\\') {
                stringBuffer.append('\\').append(c2);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String substituteEnvVars(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("<%");
        int n2 = string.indexOf("%>");
        if (n != -1 && n2 != -1) {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            while (!bl && (n3 = string.indexOf("<%", n4)) != -1) {
                if (n3 > n4) {
                    stringBuffer.append(string.substring(n4, n3));
                }
                if ((n3 = (n4 = n3 + 2) < string.length() ? string.indexOf("%>", n4) : -1) != -1) {
                    String string2 = string.substring(n4, n3).trim();
                    String string3 = System.getProperty(string2);
                    if (string3 != null) {
                        stringBuffer.append(string3);
                    } else {
                        HCUtil.logError("HCProviderFile.substituteEnvVars: no value for " + string2 + " in " + string);
                    }
                    n4 = n3 + 2;
                    bl = n4 == string.length();
                    continue;
                }
                HCUtil.logError("HCProviderFile.substituteEnvVars: mismatched angle brackets in " + string);
                break;
            }
            if (!bl) {
                stringBuffer.append(string.substring(n4));
            }
            return stringBuffer.toString();
        }
        if (n != -1 || n2 != -1) {
            HCUtil.logError("mismatched <% %> in " + string);
            return null;
        }
        return string;
    }

    static String computeFileMD5(File file) {
        String string = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(new FileInputStream(file), messageDigest);
            byte[] byArray = new byte[4096];
            while (digestInputStream.read(byArray, 0, 4096) != -1) {
            }
            string = HCUtil.bytesToHexString(messageDigest.digest());
        }
        catch (Exception exception) {
            HCUtil.logException(exception);
        }
        return string;
    }

    static String computeFileSHA256(File file) {
        String string = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            DigestInputStream digestInputStream = new DigestInputStream(new FileInputStream(file), messageDigest);
            byte[] byArray = new byte[8192];
            while (digestInputStream.read(byArray, 0, 8192) != -1) {
            }
            string = HCUtil.bytesToHexString(messageDigest.digest());
        }
        catch (Exception exception) {
            HCUtil.logInfo("computeFileSHA256: need to fix permission issues");
            HCUtil.logException(exception);
        }
        return string;
    }

    public static String execCommand(String string) {
        String string2 = null;
        try {
            Process process = Runtime.getRuntime().exec(string);
            CommandOutputThread commandOutputThread = new CommandOutputThread(process.getInputStream());
            CommandOutputThread commandOutputThread2 = new CommandOutputThread(process.getErrorStream());
            commandOutputThread.start();
            commandOutputThread2.start();
            int n = process.waitFor();
            if (n != 0) {
                HCUtil.logError("Command " + string + " failed; return = " + n + "; error output = " + commandOutputThread2.getOutput());
            }
            string2 = commandOutputThread.getOutput();
        }
        catch (Exception exception) {
            HCUtil.logException(exception);
        }
        return string2;
    }

    public static String execInShell(String string) {
        String[] stringArray = new String[]{"/bin/sh", "-c", string};
        String string2 = null;
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            CommandOutputThread commandOutputThread = new CommandOutputThread(process.getInputStream());
            CommandOutputThread commandOutputThread2 = new CommandOutputThread(process.getErrorStream());
            commandOutputThread.start();
            commandOutputThread2.start();
            int n = process.waitFor();
            if (n != 0) {
                HCUtil.logError("Command " + stringArray[0] + " " + stringArray[1] + " " + stringArray[3] + " failed; return = " + n + "; error output = " + commandOutputThread2.getOutput());
            }
            string2 = commandOutputThread.getOutput();
        }
        catch (Exception exception) {
            HCUtil.logException(exception);
        }
        return string2;
    }

    public static String byteArrayToString(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length && 0 != byArray[n]; ++n) {
        }
        return 0 == n ? "" : new String(byArray, 0, n);
    }
}

